Ext.data.JsonP.sol_common_web_ActionHelper({"tagname":"class","name":"sol.common.web.ActionHelper","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"uses":true,"members":true,"code_type":true,"singleton":true},"files":[{"filename":"sol.common.web.js","href":"sol.common.web.html#sol-common-web-ActionHelper"}],"elojc":true,"requires":["sol.common.web.ActionHandler"],"aliases":{},"alternateClassNames":[],"extends":"sol.Base","mixins":[],"uses":[],"members":[{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"logger","tagname":"property","owner":"sol.Base","id":"property-logger","meta":{"protected":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"executeAdvancedAction","tagname":"method","owner":"sol.common.web.ActionHelper","id":"method-executeAdvancedAction","meta":{}},{"name":"executeSimpleAction","tagname":"method","owner":"sol.common.web.ActionHelper","id":"method-executeSimpleAction","meta":{"private":true}},{"name":"getConfigObject","tagname":"method","owner":"sol.common.web.ActionHelper","id":"method-getConfigObject","meta":{"private":true}},{"name":"handleExecuteAction","tagname":"method","owner":"sol.common.web.ActionHelper","id":"method-handleExecuteAction","meta":{"private":true}},{"name":"handlePrecondition","tagname":"method","owner":"sol.common.web.ActionHelper","id":"method-handlePrecondition","meta":{"private":true}},{"name":"handleSimpleActionTypes","tagname":"method","owner":"sol.common.web.ActionHelper","id":"method-handleSimpleActionTypes","meta":{"private":true}},{"name":"handleTreeSelection","tagname":"method","owner":"sol.common.web.ActionHelper","id":"method-handleTreeSelection","meta":{"private":true}},{"name":"handleTypeSelection","tagname":"method","owner":"sol.common.web.ActionHelper","id":"method-handleTypeSelection","meta":{"private":true}},{"name":"initActionCfg","tagname":"method","owner":"sol.common.web.ActionHelper","id":"method-initActionCfg","meta":{"private":true}},{"name":"initialize","tagname":"method","owner":"sol.Base","id":"method-initialize","meta":{"private":true}},{"name":"prepareCfgObj","tagname":"method","owner":"sol.common.web.ActionHelper","id":"method-prepareCfgObj","meta":{"private":true}}],"code_type":"ext_define","singleton":true,"id":"class-sol.common.web.ActionHelper","classIcon":"icon-singleton","superclasses":["sol.Base"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><strong>sol.common.web.ActionHelper</strong></div></div><h4>Requires</h4><div class='dependency'><a href='#!/api/sol.common.web.ActionHandler' rel='sol.common.web.ActionHandler' class='docClass'>sol.common.web.ActionHandler</a></div><h4>Files</h4><div class='dependency'><a href='source/sol.common.web.html#sol-common-web-ActionHelper' target='_blank'>sol.common.web.js</a></div></pre><div class='doc-contents'><p>This class provides helper functions for executing complex actions.</p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-requiredConfig' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Logger for this class instance. ...</div><div class='long'><p>Logger for this class instance. This logger is created by <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a>.</p>\n\n<p>Please see <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a> class documentation for more information.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-executeAdvancedAction' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.web.ActionHelper'>sol.common.web.ActionHelper</span><br/><a href='source/sol.common.web.html#sol-common-web-ActionHelper-method-executeAdvancedAction' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.web.ActionHelper-method-executeAdvancedAction' class='name expandable'>executeAdvancedAction</a>( <span class='pre'>objId, cfg</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Helps in executing advanced actions that include precondition checks and\ndifferent object types. ...</div><div class='long'><p>Helps in executing advanced actions that include precondition checks and\ndifferent object types.</p>\n\n<p>Advanced action configurations are handled in the following order:</p>\n\n<ol>\n<li>select types (optional)</li>\n<li>check preconditions (type selection possible if returned by check) (optional)</li>\n<li>select target (optional)</li>\n<li>execute action (IX/ AS) (required)</li>\n</ol>\n\n\n<p>Please note that step 1 and 2 can be used for selecting types. If a special function\nis used for type selection (Step 1), the user selection is overriden if a second\ntype selection is handled by step 2.</p>\n\n<pre><code>{\n  preconditions: {\n    fct: 'RF_sol_contact_service_CheckContactPreconditions',\n  },\n  fct: 'RF_sol_contact_action_CreateContact',\n  cfgTemplate: '{\n         \"parentId\": \"{{objId}}\",\n         \"contactType\": \"{{type.name}},\n         \"templateId\": \"{{type.objId}}\n  }',\n  locale: {\n      errorDlgTitle: locale['sol.contact.client.contact.create.dialog.error.title'],\n      typesDlgTitle: locale['sol.contact.client.contact.create.dialog.title'],\n      typesDlgHeader: locale['sol.contact.client.contact.create.dialog.header'],\n      typesDlgText: locale['sol.contact.client.contact.create.dialog.text'],\n      typesDlgNoTypes: locale['sol.contact.client.contact.create.msg.notype'],\n\n      targetDlgTitle: locale['sol.contact.client.contact.create.dialog.title'],\n      targetDlgHeader: locale['sol.contact.client.contact.create.dialog.header'],\n      targetDlgText: locale['sol.contact.client.contact.create.dialog.text'],\n  }\n}\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>cfg</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-executeSimpleAction' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.web.ActionHelper'>sol.common.web.ActionHelper</span><br/><a href='source/sol.common.web.html#sol-common-web-ActionHelper-method-executeSimpleAction' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.web.ActionHelper-method-executeSimpleAction' class='name expandable'>executeSimpleAction</a>( <span class='pre'>objId, cfg</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>cfg</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-getConfigObject' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.web.ActionHelper'>sol.common.web.ActionHelper</span><br/><a href='source/sol.common.web.html#sol-common-web-ActionHelper-method-getConfigObject' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.web.ActionHelper-method-getConfigObject' class='name expandable'>getConfigObject</a>( <span class='pre'>cfgTemplate, data</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>cfgTemplate</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>data</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-handleExecuteAction' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.web.ActionHelper'>sol.common.web.ActionHelper</span><br/><a href='source/sol.common.web.html#sol-common-web-ActionHelper-method-handleExecuteAction' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.web.ActionHelper-method-handleExecuteAction' class='name expandable'>handleExecuteAction</a>( <span class='pre'>objId, cfg, actionCfg</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>handles the final execution of the action. ...</div><div class='long'><p>handles the final execution of the action.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>cfg</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>actionCfg</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-handlePrecondition' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.web.ActionHelper'>sol.common.web.ActionHelper</span><br/><a href='source/sol.common.web.html#sol-common-web-ActionHelper-method-handlePrecondition' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.web.ActionHelper-method-handlePrecondition' class='name expandable'>handlePrecondition</a>( <span class='pre'>objId, cfg, actionCfg, readyFct</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>handles precondition checks for advanced actions. ...</div><div class='long'><p>handles precondition checks for advanced actions.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>cfg</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>actionCfg</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>readyFct</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-handleSimpleActionTypes' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.web.ActionHelper'>sol.common.web.ActionHelper</span><br/><a href='source/sol.common.web.html#sol-common-web-ActionHelper-method-handleSimpleActionTypes' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.web.ActionHelper-method-handleSimpleActionTypes' class='name expandable'>handleSimpleActionTypes</a>( <span class='pre'>types, objId, cfg, actionCfg, readyFct</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>handles simple selection of different types. ...</div><div class='long'><p>handles simple selection of different types.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>types</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>objId</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>cfg</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>actionCfg</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>readyFct</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-handleTreeSelection' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.web.ActionHelper'>sol.common.web.ActionHelper</span><br/><a href='source/sol.common.web.html#sol-common-web-ActionHelper-method-handleTreeSelection' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.web.ActionHelper-method-handleTreeSelection' class='name expandable'>handleTreeSelection</a>( <span class='pre'>objId, cfg, actionCfg, readyFct</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>cfg</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>actionCfg</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>readyFct</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-handleTypeSelection' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.web.ActionHelper'>sol.common.web.ActionHelper</span><br/><a href='source/sol.common.web.html#sol-common-web-ActionHelper-method-handleTypeSelection' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.web.ActionHelper-method-handleTypeSelection' class='name expandable'>handleTypeSelection</a>( <span class='pre'>objId, cfg, actionCfg, readyFct</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>cfg</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>actionCfg</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>readyFct</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-initActionCfg' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.web.ActionHelper'>sol.common.web.ActionHelper</span><br/><a href='source/sol.common.web.html#sol-common-web-ActionHelper-method-initActionCfg' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.web.ActionHelper-method-initActionCfg' class='name expandable'>initActionCfg</a>( <span class='pre'>objId</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-initialize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n</div></li></ul></div></div></div><div id='method-prepareCfgObj' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.web.ActionHelper'>sol.common.web.ActionHelper</span><br/><a href='source/sol.common.web.html#sol-common-web-ActionHelper-method-prepareCfgObj' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.web.ActionHelper-method-prepareCfgObj' class='name expandable'>prepareCfgObj</a>( <span class='pre'>cfgTemplate, actionCfg</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>cfgTemplate</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>actionCfg</span> : Object<div class='sub-desc'></div></li></ul></div></div></div></div></div></div></div>","meta":{"elojc":true,"singleton":true}});